
import java.lang.Math;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.Date;
import java.sql.Timestamp;

public class TradeGenerator {

    private Random rand;
    private Timestamp time;
    private String ticker;
    private double price;
    private double size;

    private double growth;
    private double magnitude;
    private int volume;

    public TradeGenerator (double seed) {
        this(seed, 0.7, 0, 1000);
        int order = (int)Math.floor(Math.log10(seed));
        this.magnitude = Math.max(10, Math.pow(10, order - 1));
    }

    public TradeGenerator (double seed, double growth, double magnitude, int volume) {
        this.rand = new Random();
        this.ticker = newSymbol(1 + rand.nextInt(3));
        this.price = seed;
        this.time = new Timestamp(new Date().getTime());
        this.growth = growth;
        this.magnitude = magnitude;
        this.volume = volume;
    }

    public Object[][][] simulate (int n) {
        double bid, ask, changeRatio = (1 - growth);
        int bidSize, askSize;
        Object[][] trades = new Object[n][4];
        ArrayList<Object[]> quotes = new ArrayList<Object[]>();

        for (int i = 0; i < n; i++) {
            time  = new Timestamp(time.getTime() + rand.nextInt(100));
            price = Math.round(100.0 * (price + magnitude * (rand.nextDouble() - changeRatio))) / 100.0;
            size  = rand.nextInt(volume);
            trades[i] = new Object[]{time, ticker, price, size};

            for (int j = 0; j < 1 + rand.nextInt(10); j++) {
                bid = Math.round(100.0 * (price + rand.nextDouble() - changeRatio)) / 100.0;
                ask = Math.round(100.0 * (price + rand.nextDouble() - changeRatio)) / 100.0;
                bidSize = rand.nextInt(1 + (int)Math.ceil(size * 1.1));
                askSize = rand.nextInt(1 + (int)Math.ceil(size * 1.1));
                quotes.add(new Object[]{time, ticker, bid, bidSize, ask, askSize});
            }
        }
        return new Object[][][]{quotes.toArray(new Object[quotes.size()][6]), trades};
    }

    public String getSymbol () { return ticker; }

    private String newSymbol (int size) {
        char[] data = new char[size];
        for (int i = 0; i < size; i++) data[i] = (char)(65 + rand.nextInt(26));
        return new String(data);
    }

}
